importPackage(java.lang);
importPackage(java.util);
importPackage(java.io);
importPackage(Packages.javax.xml);
importPackage(Packages.javax.xml.parsers);
importPackage(Packages.javax.xml.transform);
importPackage(Packages.javax.xml.transform.dom);
importPackage(Packages.javax.xml.transform.stream);
importPackage(Packages.org.w3c.dom);

importClass(Packages.com.alarmpoint.integrationagent.apxml.APXMLMessage);
importClass(Packages.com.alarmpoint.integrationagent.apxml.APXMLToken);

importClass(Packages.org.apache.commons.httpclient.Header);
importClass(Packages.org.apache.commons.httpclient.HttpVersion);
importClass(Packages.org.mule.providers.http.HttpResponse);

/**
 * ---------------------------------------------------------------------------------------------------------------------
 * apia_http
 *
 * This is the entry point for HTTP requests from Remedy that initiate operations.
 *
 * ---------------------------------------------------------------------------------------------------------------------
 */
function apia_http(httpRequestProperties, httpResponse)
{
    // Log some info
    ServiceAPI.getLogger().debug("Enter - apia_http");
    ServiceAPI.getLogger().debug("httpRequestProperties: " + httpRequestProperties);

    // Parse the incoming payload
    var body = httpRequestProperties.getProperty( "REQUEST_BODY" );

    // If it is a POST, then JSON parse the body, otherwise we assume GET
    if( httpRequestProperties.getProperty( "http.method" ) == "POST" ) {
      requestPayload = JSON.parse( body );
    }
    else {
      // Just a helper function to parse the ?item=value&other=otherval 
      // into a json object
      requestPayload = parseQueryString( body );
    }
    // Pretend to make call to xM
    var eventID = "12345";

    //
    // Build the response object
    // Set the headers
    var header = new Header("Content-Type", "application/json" );
    httpResponse.setHeader( header );
  
    // We'll return a JSON payload
    var responsePayload = {
      "xM Event ID": eventID,
      "Other Stuff": "Other value",
      "From Request": requestPayload.item

    }
    // The http status code of 200 means A-OK.
    httpResponse.setStatusLine( HttpVersion.HTTP_1_1, 200 );
    httpResponse.setBodyString( JSON.stringify( responsePayload ) );
  
    ServiceAPI.getLogger().debug("Exit - apia_http");

    return httpResponse;
}

function parseQueryString( str ) {

  var jsonObj = {};

  // Split on ? and take the second part, then split on &
  var parmsArray = str.substr( str.indexOf( "?" ) + 1 ).split( "&" );

  for( var i in parmsArray ) {
    temp = parmsArray[i].split( "=" );
    name = temp[0];
    val  = temp[1];
    jsonObj[ name ] = val;
  }
  
  return jsonObj;
}
 
